//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Representar el ejemplo 3
// Fecha:    X.21.8.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph(), xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 5, Ymin = -5, Ymax = 5, Extra = 0.5;

// Grosor de las líneas
defaultpen(0.5);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=black);

// Formato de texto de los dos ejes
pen FormatoTexto = black+fontsize(3pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// Las gráficas
// Las gráficas
real F(real x) { return (8/x); }
path Grafica=graph(F,Xmin,-1.5,n=100);
draw(Grafica,blue+1bp);
path Grafica=graph(F,1.5,Xmax,n=100);
draw(Grafica,blue+1bp);
draw(circle((0,0),sqrt(20)),heavygreen+1bp);

// Los puntos de corte
dot((4,2),red+2bp);
dot((2,4),red+2bp);
dot((-4,-2),red+2bp);
dot((-2,-4),red+2bp);
