//---------------------------------------------------------------
// Fichero:  grafica.asy
// Objetivo: Representar la gráfica de la función
// Fecha:    D.6.10.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(8pt);

// Los ejes
draw((0,0)--(10.25,0));
draw((0,0)--(0,7.25));

// El eje de ordenadas
for ( int i=1 ; i<=7 ; ++i )
    {
    label(string(i), (0,i), 2*W, Formato);
    draw((-0.1,i)--(0.1,i));
    }

// El eje de absisas
for ( int i=0 ; i<=10 ; ++i )
    {
    label(string(10*i), (i,0), 1.5*S, Formato);
    draw((i,-0.05)--(i,0.05));
    }

// La gráfica
real F(real x) { return (6.85*0.5^(x/2.8)); }
path Grafica=graph(F,0,10,n=100);
draw(Grafica,linewidth(2bp)+blue);
