//---------------------------------------------------------------
// Fichero:  inversa.asy
// Objetivo: Función de proporcionalidad inversa
// Fecha:    J.19.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -4, Ymax = 4;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (1/x); }
path Grafica1=graph(F,Xmin,-0.25,n=100);
path Grafica2=graph(F,0.25,Xmax,n=100);
draw(Grafica1);
draw(Grafica2);
