//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Representación de las gráficas de log3(x) y 3^x
// Fecha:    V.13.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de los ejes
real Xmin = -1.5, Xmax = 9.5, Ymin = -1.5, Ymax = 9.5;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica del logaritmo
real F(real x) { return (log(x)/log(3)); }
path Grafica=graph(F,0.2,Xmax,n=100);
draw(Grafica);

// La gráfica de la exponencial
real F(real x) { return 3^x; }
path Grafica=graph(F,Xmin,2.05,n=200);
draw(Grafica);

// Algunas abscisas y ordenadas
real AO[]={-1, 1, 2, 3, 4, 5, 6, 7, 8, 9};
real Desp=0.1;
for ( int i=0 ; i<AO.length ; ++i )
    {
    // Abscisas
    draw((AO[i],-Desp)--(AO[i],Desp),gray);
    label(string(AO[i]),(AO[i],0),2S);

    // Ordenadas
    draw((-Desp,AO[i])--(Desp,AO[i]),gray);
    label(string(AO[i]),(0,AO[i]),2W);
    }

// Los puntos
pen FormatoPunto=blue+5bp;
dot((1,0),FormatoPunto);
dot((0,1),FormatoPunto);
dot((3,1),FormatoPunto);
dot((1,3),FormatoPunto);
dot((9,2),FormatoPunto);
dot((2,9),FormatoPunto);
dot((0.3333,-1),FormatoPunto);
dot((-1,0.3333),FormatoPunto);

// La bisectriz
pen Punteado = linetype(new real[] {2,2});
draw((-1,-1) -- (9.2,9.2), Punteado+gray);
