//---------------------------------------------------------------
// Fichero:  mayor1.asy
// Objetivo: Función logarítmica con a>1
// Fecha:    L.9.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -0.5, Xmax = 4, Ymin = -4, Ymax = 4;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (log(x)/log(1.4)); }
path Grafica=graph(F,0.275,Xmax-0.3,n=100);
draw(Grafica);

// Dos puntos
dot((1,0),deepgreen+4bp);
dot((1.4,1),red+4bp);
