//---------------------------------------------------------------
// Fichero:  segmentos.asy
// Objetivo: Representar segmentos que se cortan
// Fecha:    L.18.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(0.75);

// Los ángulos que determinan los extremos de los segmentos
int Ang[]={15,130,60,190,90,-10,80,200};

// Los segmentos
path Seg[];
for ( int i=0 ; i<Ang.length ; i+=2 )
    {
    Seg[floor(i/2)]=dir(Ang[i])--dir(Ang[i+1]);
    draw(Seg[floor(i/2)]);
    }

// Los puntos de corte
for ( int i=0 ; i<Seg.length-1 ; ++i )
    {
    for ( int j=i+1 ; j<Seg.length ; ++j )
        { dot(intersectionpoint(Seg[i],Seg[j]),2bp+heavygreen); }
    }
