//---------------------------------------------------------------
// Fichero:  partes.asy
// Objetivo: Dar un ejemplo de partes de un conjunto
// Fecha:    M.14.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Función que dibuja un conjunto
void Conjunto(bool R, bool G, bool B, int Mov)
    {
    transform M = shift(Mov,0);
    path C=scale(0.75)*unitcircle;
    if (R) { fill(M*shift(dir(90))*C, red); }
    if (G) { fill(M*shift(dir(210))*C, deepgreen); }
    if (B) { fill(M*shift(dir(-30))*C, blue); }
    path C=scale(2)*unitcircle;
    draw(M*C,2bp+black);
    }

// El conjunto
Conjunto(true,true,true,0);

// Las partes
Conjunto(false,false,false,10);

Conjunto(true,false,false,15);
Conjunto(false,true,false,20);
Conjunto(false,false,true,25);

Conjunto(true,true,false,30);
Conjunto(true,false,true,35);
Conjunto(false,true,true,40);

Conjunto(true,true,true,45);

// La caja
draw(box((7.5,-2.5),(47.5,2.5)),2bp+gray);

// Los textos
pen FT=Helvetica(series="m",shape="n")+fontsize(24pt);
label("A",(0,4),FT);
label("P(A)",(27.5,4),FT);
label("$\Rightarrow$",(5,0),FT);
