//---------------------------------------------------------------
// Fichero:  esquema.asy
// Objetivo: Dar un esquema de la propiedad
// Fecha:    D.14.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(2);

// Formato de texto
pen Formato=black+fontsize(14pt)+Bookman(series="b",shape="n");

// Constantes
real Sep=2.5, Altura=4, Base1=18, Base2=34;

// Los m+1 elementos originales
for ( int i=0 ; i<5 ; ++i )
    { draw(shift(Sep*i,Altura)*unitcircle); }
draw((-1.5,Altura+0.5)--(-1.5,Altura+1.5)--
     (1.5+4*Sep,Altura+1.5)--(1.5+4*Sep,Altura+0.5),
     1.5bp+blue);
label("m+1",(2*Sep,Altura+Sep),Formato);

// Los m+1 elementos separados
for ( int i=0 ; i<5 ; ++i )
    { draw(shift(Base1+Sep*i,Altura)*unitcircle); }
draw(shift(Base1,Altura)*(dir(45)--dir(225)));
draw(shift(Base1,Altura)*(dir(-45)--dir(135)));
draw((Base1-1.5,Altura+0.5)--(Base1-1.5,Altura+1.5)--
     (Base1+1.5+4*Sep,Altura+1.5)--(Base1+1.5+4*Sep,Altura+0.5),
     1.5bp+blue);
draw((Base1+0.5*Sep,Altura+0.5)--(Base1+0.5*Sep,Altura+1.5),1.5bp+blue);
label("1",(Base1,Altura+Sep),Formato);
label("m",(Base1+2.5*Sep,Altura+Sep),Formato);

// Los m elementos acompañados
for ( int i=0 ; i<5 ; ++i )
    { draw(shift(Base2+Sep*i,Altura)*unitcircle); }
draw(shift(Base2,Altura)*(dir(45)--dir(225)));
draw(shift(Base2,Altura)*(dir(-45)--dir(135)));
draw((Base2+0.5*Sep,Altura+0.5)--(Base2+0.5*Sep,Altura+1.5)--
     (Base2+1.5+4*Sep,Altura+1.5)--(Base2+1.5+4*Sep,Altura+0.5),
     1.5bp+blue);
label("m",(Base2+2.5*Sep,Altura+Sep),Formato);

// Los n+1 elementos originales
real Sep=2.5, Altura=-4;
for ( int i=1 ; i<4 ; ++i )
    { draw(shift(Sep*i,Altura)*unitcircle); }
draw((-1.5+Sep,Altura-0.5)--(-1.5+Sep,Altura-1.5)--
     (1.5+3*Sep,Altura-1.5)--(1.5+3*Sep,Altura-0.5),
     1.5bp+blue);
label("n+1",(2*Sep,Altura-Sep),Formato);

// Los n+1 elementos acompañados
for ( int i=1 ; i<4 ; ++i )
    { draw(shift(Base1+Sep*i,Altura)*unitcircle); }
draw(shift(Base1+Sep,Altura)*(dir(45)--dir(225)));
draw(shift(Base1+Sep,Altura)*(dir(-45)--dir(135)));
draw((Base1-1.5+Sep,Altura-0.5)--(Base1-1.5+Sep,Altura-1.5)--
     (Base1+1.5+3*Sep,Altura-1.5)--(Base1+1.5+3*Sep,Altura-0.5),
     1.5bp+blue);
draw((Base1+1.5*Sep,Altura-0.5)--(Base1+1.5*Sep,Altura-1.5),1.5bp+blue);
label("1",(Base1+Sep,Altura-Sep),Formato);
label("n",(Base1+2.5*Sep,Altura-Sep),Formato);

// Los n+1 elementos
for ( int i=1 ; i<4 ; ++i )
    { draw(shift(Base2+Sep*i,Altura)*unitcircle); }
draw((Base2-1.5+Sep,Altura-0.5)--(Base2-1.5+Sep,Altura-1.5)--
     (Base2+1.5+3*Sep,Altura-1.5)--(Base2+1.5+3*Sep,Altura-0.5),
     1.5bp+blue);
label("n+1",(Base2+2*Sep,Altura-Sep),Formato);

// Las flechas
real Origen=2;
draw((2*Sep,Origen)--(2*Sep,-Origen),deepgreen+1.5bp,
      Arrow(size=3mm),BeginBar(size=1.8mm));
draw((Base1+2.5*Sep,Origen)--(Base1+2.5*Sep,-Origen),deepgreen+1.5bp,
      Arrow(size=3mm),BeginBar(size=1.8mm));
draw((Base2+2.5*Sep,Origen)--(Base2+2*Sep,-Origen),deepgreen+1.5bp,
      Arrow(size=3mm),BeginBar(size=1.8mm));

// Las fórmulas
pen Formato1=black+fontsize(18pt)+Bookman(series="b",shape="n");
pen Formato2=black+fontsize(10pt)+Bookman(series="b",shape="n");
label("C",(2.5*Sep,0),Formato1);
label("m+1,n+1",(2.5*Sep+0.5,-0.4),E,Formato2);
label("C",(Base1+3*Sep,0),Formato1);
label("m,n",(Base1+3*Sep+0.5,-0.4),E,Formato2);
label("C",(Base2+3*Sep,0),Formato1);
label("m,n+1",(Base2+3*Sep+0.5,-0.4),E,Formato2);
label("=",(15,-0.5),Formato);
label("+",(33,-0.5),Formato);
