//---------------------------------------------------------------
// Fichero:  triangulopascalsumas.asy
// Objetivo: Representar el triángulo de Pascal con sumas
// Fecha:    M.26.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.75cm);

// Grosor de las líneas
defaultpen(1);

// El número de líneas que vamos a generar
int n=6;

// Función que escribe un valor en un hexágono
void Escribe(path H, int F, int C)
    {
    pair T=(point(H,0)+point(H,3))/2;
    label(string(choose(F,C)),T,fontsize(14pt));
    // Las flechitas
    if ( F != n-1 )
        {
        real Ext=0.25;
        // Derecha
        pair M=(point(H,0)+point(H,5))/2;
        draw(M-Ext*dir(-60)--M+Ext*dir(-60),
             1bp+heavygreen,Arrow(TeXHead,1bp));
        // Izquierda
        pair M=(point(H,4)+point(H,5))/2;
        draw(M-Ext*dir(-120)--M+Ext*dir(-120),
             1bp+heavygreen,Arrow(TeXHead,1bp));
        }
    }

// Desplazamientos
real DespHorz=sqrt(3);
real DespVert=-1.5;

// El hexágono base
path Hexagono=rotate(30)*polygon(6);

// Las filas
real Izq=0;
for ( int Fil=0 ; Fil<n ; ++Fil )
    {
    Izq=-DespHorz*Fil/2;
    // Las columnas
    for ( int Col=0 ; Col<Fil+1 ; ++Col )
        {
        path Hex=shift(Izq,Fil*DespVert)*Hexagono;
        draw(Hex);
        Escribe(Hex,Fil,Col);
        Izq += DespHorz;
        }
    }

