//---------------------------------------------------------------
// Fichero:  pentagono.asy
// Objetivo: Dibujar diagonal y lado de un pentágono regular
// Fecha:    M.30.1.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El pentágono
path Pentagono=polygon(5);
draw(Pentagono);

// La diagonal
pair A=point(Pentagono,1), B=point(Pentagono,3);
draw(A--B,2bp+blue);

// El lado
pair C=point(Pentagono,0), D=point(Pentagono,4);
draw(C--D,2bp+blue);

// Los nombres
pen FormatoTexto=fontsize(8pt);
label("diagonal", (A+B)/2, S, FormatoTexto);
label("lado", (C+D)/2, N, FormatoTexto);
