//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Representar la resolución 1
// Fecha:    M.13.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// La raíz
real Raiz5=sqrt(5);

// Los ejes de coordenadas
draw((0,0) -- (Raiz5+0.2,0));
draw((0,0) -- (0,1.1));

// El ángulo recto
markrightangle((2,1), (2,0), (0,0), 3mm, 0.5bp+gray);

// Líneas auxiliares
draw((0,0)--(2,1),gray);
draw((2,0)--(2,1),gray);
draw((0,1)--(2,1),gray);
draw(arc((0,0),Raiz5,0,30),magenta);

// Los puntos
dot((0,0),3bp+black);
dot((2,1),3bp+black);
pair A=(2,0); dot(A,4bp+blue); label("$2$",A,S);
pair B=(0,1); dot(B,4bp+blue); label("$1$",B,W);
pair C=(Raiz5,0); dot(C,4bp+deepgreen); label("$\sqrt{5}$",C,S);
pair D=(1,0); dot(D,3bp+blue); label("$1$",D,S);
pair E=(0,0); dot(E,3bp+blue); label("$0$",E,S);

// Longitud de la hipotenusa
label("$\sqrt{5}$",(1,0.5),N);
