//---------------------------------------------------------------
// Fichero:  estrella3.asy
// Objetivo: Tercer paso para generar la estrella tartésica
// Fecha:    V.8.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Un cuadrado
path Cuadrado1=box((-1,-1),(1,1));
draw(Cuadrado1);

// Lo giramos
path Cuadrado2=rotate(45)*Cuadrado1;
draw(Cuadrado2,blue);

// La estrella
pair[] Puntos=intersectionpoints(Cuadrado1,Cuadrado2);
guide Estrella;
for ( int i ; i<Puntos.length ; ++i )
    {
    real ang=degrees(Puntos[i]);
    Estrella=Estrella--Puntos[i];
    Estrella=Estrella--sqrt(2)*dir(ang+22.5);
    }
Estrella=Estrella--cycle;
draw(scale(1.1)*Estrella,deepgreen);
