//---------------------------------------------------------------
// Fichero:  resolucion2c.asy
// Objetivo: Mostrar la tercera ilustración de la resolución 2
// Fecha:    J.7.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(0.5,0), C=(0,sqrt(3)/2);

// El ángulo recto
markrightangle(B, A, C, 3mm, 1bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("$a$",(B+C)/2,E);
label("$\frac{a}{2}$",(A+B)/2,S);
label("$h$",C/2,W);
