//---------------------------------------------------------------
// Fichero:  grafica2.asy
// Objetivo: Mostrar la gráfica 2
// Fecha:    S.12.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 7, Ymin = 0, Ymax = 7, Extra = 0.25;

// Definición de los valores
int[] V={45,32,21,4,1,0, 21,57,47,17,3,1, 16,43,82,29,7,4, 10,21,65,59,12,7,
         7,15,12,37,23,8, 0,2,3,6,8,16};
int MaxV=max(V);

// Los nombres del eje de abscisas
string[] NombreX={"150","160","170","180","190", "200", "210"};

// Los nombres del eje de ordenadas
string[] NombreY={"40","55","70","85","100","115","130"};

// Grosor de las líneas
defaultpen(1);

// Los nombres
for ( int i=0 ; i<=6 ; ++i )
    {
    label(NombreX[i],(i+1,-0.25),blue+fontsize(6pt));
    label(NombreY[i],(-0.5,i+1),blue+fontsize(6pt));
    }

// Las marcas de los ejes
for ( int i=0 ; i<=6 ; ++i )
    {
    draw((i+1,-0.05)--(i+1,0.05));
    draw((-0.05,i+1)--(0.05,i+1));
    }

// Las valores
real Radio=0;
for ( int i=1 ; i<=6 ; ++i ) {
for ( int j=1 ; j<=6 ; ++j ) {
    Radio = V[6*(j-1)+i-1]/(2*MaxV);
    fill(circle((i+0.5,j+0.5),Radio),deepgreen);
    }}

// El eje de ordenadas
label("Altura",(6.5,-0.75),blue+fontsize(8pt));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
label(rotate(90)*"Masa",(-1.25,6.5),blue+fontsize(8pt));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// La marca de que cortamos un trozo de eje de ordenadas
fill(box((-0.1,0.4),(0.1,0.6)),white);
draw((-0.1,0.35)--(0.1,0.45));
draw((-0.1,0.55)--(0.1,0.65));
