//---------------------------------------------------------------
// Fichero:  positivo.asy
// Objetivo: Mostrar un coeficiente de correlación positivo
// Fecha:    D.13.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Dimensiones de los ejes
int Xmin = 0, Xmax = 8, Ymin = 0, Ymax = 4, Extra = 1;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Iniciamos el generador de números aleatorios
srand(2);

// Los puntos
for ( int i=1 ; i<9 ; ++i )
    { dot((i,0.35*i+1+2.5*(unitrand()-0.5)),3bp+deepgreen); }
