//---------------------------------------------------------------
// Fichero:  neutra.asy
// Objetivo: Mostrar una covarianza neutra
// Fecha:    D.13.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
int Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 5, Extra = 1;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Iniciamos el generador de números aleatorios
srand(8);

// Generamos los puntos
real x, y;
pair[] P;
for ( int i=0 ; i<19 ; ++i )
    {
    // La abscisa
    x=(i/2+1)+0.3*(unitrand()-0.5);

    // La ordenada
    y=2.5*(unitrand()-0.5)+2.5;

    // El punto
    P[i]=(x,y);
    }

// Las sumas de cada coordenada
real SumaX=0, SumaY=0;
for ( int i=0 ; i<P.length ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    }

// El centro de gravedad
pair CG=(SumaX,SumaY)/P.length;
draw((Xmin+0.5,CG.y) -- (Xmax+0.5,CG.y), 0.5bp+gray);
draw((CG.x,Ymin+0.5) -- (CG.x,Ymax+0.5), 0.5bp+gray);
dot(CG,3bp+deepgreen);

// Dibujamos los puntos
real Producto;
pen Color;
for ( int i=0 ; i<P.length ; ++i )
    {
    Producto = (P[i].x-CG.x)*(P[i].y-CG.y);
    Color=deepgreen;
    if ( Producto>0 ) { Color=blue; }
    if ( Producto<0 ) { Color=red; }
    dot(P[i],3bp+Color);
    }

