//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Representar gráficamente la distribución
// Fecha:    L.14.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
int Xmin = 0, Xmax = 9, Ymin = 0, Ymax = 8, Extra = 1;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
pair[] P={(1,3),(1,4),(2,5),(4,7),(4,6),(5,7),(6,8),(7,8),(8,6),(9,7)};

// Las sumas de cada coordenada
real SumaX=0, SumaY=0;
for ( int i=0 ; i<P.length ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    }

// El centro de gravedad
pair CG=(SumaX,SumaY)/P.length;
draw((Xmin+0.5,CG.y) -- (Xmax+0.5,CG.y), 0.5bp+gray);
draw((CG.x,Ymin+0.5) -- (CG.x,Ymax+0.5), 0.5bp+gray);
dot(CG,3bp+deepgreen);

// Dibujamos los puntos
real Producto;
pen Color;
for ( int i=0 ; i<P.length ; ++i )
    {
    Producto = (P[i].x-CG.x)*(P[i].y-CG.y);
    Color=deepgreen;
    if ( Producto>0 ) { Color=blue; }
    if ( Producto<0 ) { Color=red; }
    dot(P[i],3bp+Color);
    }

