//---------------------------------------------------------------
// Fichero:  estimado.asy
// Objetivo: Mostrar un valor estimado
// Fecha:    D.20.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 4, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra),gray);
draw((Xmin-Extra,0) -- (Xmax+Extra,0),gray);

// Iniciamos el generador de números aleatorios
srand(6);

// Generamos los puntos
real x, y, var;
pair[] P;
for ( int i=0 ; i<18 ; ++i )
    {
    // La abscisa
    x=(i/2+1)+0.3*(unitrand()-0.5);

    // La ordenada
    var=(unitrand()+0.8)/2 * (unitrand()>0.5 ? 1 : -1);
    y=0.25*(i/2+0.2)+1+var;

    // El punto
    P[i]=(x,y);
    }

// Número de datos
int n=P.length;

// Las sumas estadisticas
real SumaX=0, SumaY=0, SumaX2=0, SumaXY=0;
for ( int i=0 ; i<n ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    SumaX2 += (P[i].x)^2;
    SumaXY += (P[i].x)*(P[i].y);
    }

// El centro de gravedad
real MediaX=SumaX/n;
real MediaY=SumaY/n;
pair CG=(MediaX,MediaY);

// El coeficiente de regresión
real CR=(SumaXY/n-MediaX*MediaY)/(SumaX2/n-MediaX^2);

// La recta de regresión
pair V=unit((1,CR)), A=CG-5V, B=CG+5V;
path RR=A -- B;
draw(RR);

// Dibujamos los puntos
for ( int i=0 ; i<n ; ++i )
    { dot(P[i],2bp+deepgreen); }

// Un valor de x:
x=5.4;
draw((x,-0.1) -- (x,0.1),0.75bp+blue);
label("$x$",(x,-0.3),fontsize(6pt));

// Valor estimado de y:
pair Q=intersectionpoint(RR,(x,Ymin)--(x,Ymax));
y=Q.y;
draw((-0.1,y) -- (0.1,y),0.75bp+blue);
label("$\hat{y}$",(-0.5,y),fontsize(6pt));

// Mostramos bien el punto de corte
draw((x,0) -- Q,0.5bp+blue);
draw((0,y) -- Q,0.5bp+blue);
dot(Q,3bp+blue);
