//---------------------------------------------------------------
// Fichero:  hexagonal.asy
// Objetivo: Representar varias retículas hexagonales
// Fecha:    L.4.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Grosor de las líneas
defaultpen(1);

// El hexágono regular básico
path Hex=rotate(30)*polygon(6);

// Tenemos varias figuras
int NumFig=5, Sep=7;

// Los números de cada figura
int Dato[]={2,5,1,6,3,7,4,   5,7,1,2,4,3,6,   3,5,1,4,7,2,6,
            4,6,7,3,5,2,1,   1,3,2,4,7,6,5};

// Repetimos el hexágono
pair Pos=(0,0);
pen FT=fontsize(14pt)+Helvetica(series="b",shape="n");
pen Color=black;
for ( int k=0 ; k<NumFig ; ++k )
    {
    Color=black;
    if (k==1 | k==3)
        { Color=blue; }
    for ( int i=0 ; i<6 ; ++i )
        {
        Pos=shift(k*Sep,0)*(sqrt(3)*dir(60*i));
        draw(shift(Pos)*Hex);
        label(string(Dato[7*k+i]),Pos,FT+Color);
        }
    Pos=(k*Sep,0);
    label(string(Dato[7*k+6]),Pos,FT+Color);
    }
