//---------------------------------------------------------------
// Fichero:  grafico3.asy
// Objetivo: Representar el gráfico 3
// Fecha:    D.20.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los cinco vectores
pair n=(5,1), r=(2,-1);
pair n1=2*n, r1=-3*r;
pair suma=n1+r1;

// Dimensiones de los ejes
real Xmin = -6, Xmax = 10, Ymin = -2, Ymax = 6, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(n1 -- suma, Punteado+gray);
draw(r1 -- suma, Punteado+gray);

// Los vectores
draw((0,0)--n, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--n1, 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--r, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--r1, 1.5bp+orange,Arrow(HookHead,5pt));
draw((0,0)--suma, 1.5bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$2\vec{n}-3\vec{r}$",suma,N,FormatoTexto);
label("$\vec{n}$",n,N,FormatoTexto);
label("$2\vec{n}$",n1,NE,FormatoTexto);
label("$\vec{r}$",r,S,FormatoTexto);
label("$-3\vec{r}$",r1,W,FormatoTexto);
