//---------------------------------------------------------------
// Fichero:  grafico4.asy
// Objetivo: Representar el gráfico 4
// Fecha:    D.20.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los cinco vectores
pair s=(10,5), u=(6,-3);
pair s1=(3/5)*s, u1=-u;
pair suma=s1+u1;

// Dimensiones de los ejes
real Xmin = -6, Xmax = 10, Ymin = -3, Ymax = 6, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(s1 -- suma, Punteado+gray);
draw(u1 -- suma, Punteado+gray);

// Los vectores
draw((0,0)--s, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--s1, 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--u, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--u1, 1.5bp+orange,Arrow(HookHead,5pt));
draw((0,0)--suma, 1.5bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\frac{3}{5}\vec{a}-\vec{u}$",suma,NE,FormatoTexto);
label("$\vec{a}$",s,NE,FormatoTexto);
label("$\frac{3}{5}\vec{a}$",s1,S,FormatoTexto);
label("$\vec{u}$",u,E,FormatoTexto);
label("$-\vec{u}$",u1,W,FormatoTexto);
