//---------------------------------------------------------------
// Fichero:  solucion6.asy
// Objetivo: Representar la solución 6
// Fecha:    D.4.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 3, Ymin = -3, Ymax = 2, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos y el origen
pair F=(3,0), G=(-4,-3), H=(-2,2), O=(0,0);

// Los vectores
pen FormatoTexto = black+fontsize(8pt);
draw(O -- F, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=F/2+0.4N;
label("OF",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- G, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=4G/5+0.4NW;
label("OG",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- H, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=H/2+0.4SW;
label("OH",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- F+G, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(F+G)/2+W;
label("OF+OG",Pos,FormatoTexto);
draw(Pos+(-0.8,0.25) -- Pos+(-0.2,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(Pos+(0.2,0.25) -- Pos+(0.8,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));
pair R=(2/3)*F-(1/2)*H;
draw(O -- R, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=R+0.4S+1.5W;
label("$\frac{2}{3}$OF-$\frac{1}{2}$OH",Pos,FormatoTexto);
draw(Pos+(-0.7,0.25) -- Pos+(-0.1,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(Pos+(0.4,0.25) -- Pos+(1,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(F, FormatoPunto);
dot(G, FormatoPunto);
dot(H, FormatoPunto);
dot(O, FormatoPunto);
pen FormatoPunto = 5bp+deepgreen;
pen FormatoTexto = black+fontsize(8pt);
label("F",F,NE,FormatoTexto);
label("G",G,S,FormatoTexto);
label("H",H,NW,FormatoTexto);
label("O",O,NE,FormatoTexto);
