//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Representar la solución 3
// Fecha:    L.5.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 6, Ymin = -2, Ymax = 3, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos y el origen
pair M=(6,3), Q=(-2,-2), R=(-3,0), O=(0,0);

// El resultado final
pair F=R-(1/2)*Q;

// Los vectores
pen FormatoTexto = black+fontsize(6pt);
draw(O -- Q, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=Q/2+0.6W;
label("OQ",Pos,FormatoTexto);
draw(Pos+(-0.32,0.25) -- Pos+(0.32,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(R -- F, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=(R+F)/2+0.75E;
label("-$\frac{1}{2}$OQ",Pos,FormatoTexto);
draw(Pos+(0,0.25) -- Pos+(0.5,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(R, FormatoPunto);
dot(Q, FormatoPunto);
dot(O, FormatoPunto);
pen FormatoPunto = 5bp+deepgreen;
dot(F, FormatoPunto);
pen FormatoTexto = black+fontsize(8pt);
label("Q",Q,SW,FormatoTexto);
label("R",R,N,FormatoTexto);
label("O",O,NE,FormatoTexto);
