//---------------------------------------------------------------
// Fichero:  tetris.asy
// Objetivo: Ilustrar el problema del tetris
// Fecha:    X.7.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definimos los puntos del problema
pair L=(0,1), M=(0,0), N=(3,0), Z=(2,2);

// El cuadrado básico
path Cuadrado=box((0,0),(1,1));

// Los cuadrados
filldraw(Cuadrado,lightgray,black);
filldraw(shift(1,0)*Cuadrado,lightgray,black);
filldraw(shift(2,0)*Cuadrado,lightgray,black);
filldraw(shift(1,1)*Cuadrado,lightgray,black);

// Los puntos
pen FormatoPunto = 3bp+black;
dot(L, FormatoPunto);
dot(M, FormatoPunto);
dot(N, FormatoPunto);
dot(Z, FormatoPunto);
pen FormatoTexto = black+fontsize(10pt);
label("L",L,W,FormatoTexto);
label("M",M,SW,FormatoTexto);
label("N",N,SE,FormatoTexto);
label("Z",Z,NE,FormatoTexto);
