//---------------------------------------------------------------
// Fichero:  enunciado1der.asy
// Objetivo: Mostrar la ilustración derecha del enunciado 1
// Fecha:    M.10.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(13cm);

// Grosor de las líneas
defaultpen(1.25);

// Los puntos
pair A=(0,0), B=(8,0), C=(13,0), D=(13,5), E=(5,5), F=(0,5), G=(5,2), H=(8,3);

// Las piezas
path P1 = A -- B -- H -- G -- cycle;
path P2 = B -- C -- D -- H -- cycle;
path P3 = G -- H -- D -- E -- cycle;
path P4 = A -- G -- E -- F -- cycle;
fill(P1,mediumblue);
fill(P2,mediumred);
fill(P3,mediummagenta);
fill(P4,mediumgreen);

// La rejilla
add(grid(13,5,1bp+white));

// Las piezas
draw(P1);
draw(P2);
draw(P3);
draw(P4);

// Los nombres de las piezas
pen FormatoTexto=Helvetica(series="m",shape="n")+fontsize(20pt);
pen ColorFondo=lightgray;
real r=0.4;

pair pos=(10.5,2);
fill(circle(pos,r),ColorFondo);
label("B",pos,FormatoTexto);

pair pos=(2.5,3);
fill(circle(pos,r),ColorFondo);
label("A",pos,FormatoTexto);

pair pos=(7,4);
fill(circle(pos,r),ColorFondo);
label("C",pos,FormatoTexto);

pair pos=(6,1);
fill(circle(pos,r),ColorFondo);
label("D",pos,FormatoTexto);
