//---------------------------------------------------------------
// Fichero:  traslacion.asy
// Objetivo: Representar una traslacion
// Fecha:    V.4.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Definición de la trasformación
pair T(pair P)
    { return (P.x+8,P.y); }

// Dimensiones de los ejes
real Xmin = 0, Xmax = 16, Ymin = 0, Ymax = 8, Extra = 0.25;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos originales
pair A=(1,3), B=(3,7), C=(7,5), D=(5,1);

// El cuadrado original
draw(A -- B -- C -- D -- A, red);

// El cuadrado imagen
draw(T(A) -- T(B) -- T(C) -- T(D) -- T(A), magenta);

// Los puntos
FormatoTexto = black+fontsize(12pt);
pen FormatoPunto = black+4bp;
dot(A, FormatoPunto);
dot(B, FormatoPunto);
dot(C, FormatoPunto);
dot(D, FormatoPunto);
label("A",A,W,FormatoTexto);
label("B",B,N,FormatoTexto);
label("C",C,N,FormatoTexto);
label("D",D,S,FormatoTexto);

// Los puntos trasformados
dot(T(A), FormatoPunto);
dot(T(B), FormatoPunto);
dot(T(C), FormatoPunto);
dot(T(D), FormatoPunto);
label("T(A)",T(A),2E,FormatoTexto);
label("T(B)",T(B),N,FormatoTexto);
label("T(C)",T(C),E,FormatoTexto);
label("T(D)",T(D),S,FormatoTexto);

// Las flechas de conexión
draw(A+0.025*(T(A)-A) -- T(A)-0.025*(T(A)-A),gray,Arrow(7bp));
draw(B+0.025*(T(B)-B) -- T(B)-0.025*(T(B)-B),gray,Arrow(7bp));
draw(C+0.025*(T(C)-C) -- T(C)-0.025*(T(C)-C),gray,Arrow(7bp));
draw(D+0.025*(T(D)-D) -- T(D)-0.025*(T(D)-D),gray,Arrow(7bp));
