//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Representar un caso de producto de número y vector
// Fecha:    L.14.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair v=(2,1), p=(-4,-2);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 2, Ymin = -2, Ymax = 1, Extra = 0.25;

// Los ejes de coordenadas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores
draw((0,0) -- p, 1.25bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 5bp+deepred);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\vec{v}$",1.1v,FormatoTexto);
label("$\alpha\vec{v}$",1.1p,FormatoTexto);
