//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Ejemplo de una traslacion
// Fecha:    L.21.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Definición de la traslación
pair T(pair P)
    { return (P.x+5,P.y+2); }

// Dimensiones de los ejes
real Xmin = -1, Xmax = 7, Ymin = -1, Ymax = 6, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos originales
pair A=(-1,-1), B=(2,2), C=(1,4);

// El triángulo original
draw(A -- B -- C -- A, red);

// El triángulo imagen
draw(T(A) -- T(B) -- T(C) -- T(A), magenta);

// Los puntos
FormatoTexto = black+fontsize(12pt);
pen FormatoPunto = black+4bp;
dot(A, FormatoPunto);
dot(B, FormatoPunto);
dot(C, FormatoPunto);
label("$A$",A,W,FormatoTexto);
label("$B$",B,W,FormatoTexto);
label("$C$",C,N,FormatoTexto);

// Los puntos trasformados
dot(T(A), FormatoPunto);
dot(T(B), FormatoPunto);
dot(T(C), FormatoPunto);
label("$T_{\vec{v}}(A)$",T(A),SE,FormatoTexto);
label("$T_{\vec{v}}(B)$",T(B),E,FormatoTexto);
label("$T_{\vec{v}}(C)$",T(C),N,FormatoTexto);

// Las flechas de conexión
draw(A+0.025*(T(A)-A) -- T(A)-0.025*(T(A)-A),gray,Arrow(7bp));
draw(B+0.025*(T(B)-B) -- T(B)-0.025*(T(B)-B),gray,Arrow(7bp));
draw(C+0.025*(T(C)-C) -- T(C)-0.025*(T(C)-C),gray,Arrow(7bp));
