//---------------------------------------------------------------
// Fichero:  sumapuntos.asy
// Objetivo: Representar la suma de dos puntos
// Fecha:    D.27.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(3,4), B=(5,-1), Suma=A+B;

// Dimensiones de los ejes
real Xmin = 0, Xmax = 8, Ymin = -1, Ymax = 4, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores
dot((0,0), 4bp+gray);
draw((0,0) -- A, 1.5bp+gray,Arrow(HookHead,5pt));
pen FormatoTexto = black+fontsize(12pt);
pair Pos=A/2+0.5NW;
label("OA",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,2pt));
draw((0,0) -- B, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=B/2+0.5S;
label("OB",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,2pt));
draw((0,0) -- Suma, 1.5bp+pink,Arrow(HookHead,5pt));
pair Pos=Suma/2+0.5SE;
label("OA+OB",Pos,FormatoTexto);
draw(Pos+(-0.55,0.2) -- Pos+(-0.15,0.2), 0.5bp+black,Arrow(HookHead,2pt));
draw(Pos+(0.15,0.2) -- Pos+(0.55,0.2), 0.5bp+black,Arrow(HookHead,2pt));

// Los puntos
pen FormatoPunto = 5bp+black;
pen FormatoTexto = black+fontsize(12pt);
dot((0,0), FormatoPunto);
label("O",(0,0),2SW,FormatoTexto);
dot(A, FormatoPunto);
label("A",A,2N,FormatoTexto);
dot(B, FormatoPunto);
label("B",B,2E,FormatoTexto);
dot(Suma, FormatoPunto);
label("A+B",Suma,2N,FormatoTexto);
