//---------------------------------------------------------------
// Fichero:  segmento.asy
// Objetivo: Representar el segmento
// Fecha:    M.6.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definimos los extremos
pair A=(0,0), B=(4,0.5);

// Calculamos el punto medio
pair M=(A+B)/2;

// Los vectores
pen FormatoTexto = black+fontsize(10pt);
draw(A -- B, 2bp+deepgreen,Arrow(HookHead,5pt));
draw(A -- M, 1bp+orange,Arrow(HookHead,5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(A, FormatoPunto);
dot(B, FormatoPunto);
dot(M, FormatoPunto);
label("A",A,N,FormatoTexto);
label("B",B,N,FormatoTexto);
label("M",M,N,FormatoTexto);
