//---------------------------------------------------------------
// Fichero:  vn.asy
// Objetivo: Representar el vector normal de una recta
// Fecha:    D.11.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -2, Xmax = 5, Ymin = -1, Ymax = 4, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair A=(-2,-0.8), B=(5,3.7);
draw(A -- B, 1.5bp+blue);
label("r",(2.5,2.8),fontsize(10pt));

// El vector de dirección
dot((0,0), 3bp+deepgreen);
pair u=B-A; u=(-u.y,u.x);
pair F=0.35*u;
draw((0,0) -- F, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{n}_r$",1.3F,deepgreen+fontsize(10pt));
