//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Representar la figura 2
// Fecha:    M.13.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 6, Ymin = 0, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair A=(-1,1), B=(6,3);
draw(A -- B, 1.5bp+blue);
label("r",B,2S,fontsize(12pt));

// El vector de dirección
pair v=0.3(B-A);
dot((0,0), 3bp+deepgreen);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}$",1.15v,deepgreen+fontsize(12pt));

// Los puntos
pen FormatoTexto=black+fontsize(12pt);
pair H=A+v, Q=H+0.5v, R=H+v, T=H+1.75v;
dot(H, 3bp+black);
dot(Q, 3bp+black);
dot(R, 3bp+black);
dot(T, 3bp+black);
label("H",H,N,FormatoTexto);
label("Q",Q,N,FormatoTexto);
label("R",R,N,FormatoTexto);
label("S",T,N,FormatoTexto);
