//---------------------------------------------------------------
// Fichero:  paralelasejes.asy
// Objetivo: Representar rectas perpendiculares paralelas a los ejes
// Fecha:    V.30.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -2, Xmax = 5, Ymin = -2, Ymax = 4, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta r
draw((Xmin,2) -- (Xmax,2), 1.5bp+blue);
label("r",(Xmax,2),E,fontsize(12pt));

// La recta s
draw((2.5,Ymin) -- (2.5,Ymax), 1.5bp+blue);
label("s",(2.5,Ymax),E,fontsize(12pt));

// El punto de intersección
pair V=(2.5,2);

// El ángulo recto
markrightangle((2.5,Ymax), V, (Xmin,2), 3mm, 0.75bp+orange);
