//---------------------------------------------------------------
// Fichero:  dosrectas.asy
// Objetivo: Representar las dos rectas obtenidas
// Fecha:    M.24.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(4,9), V=(-2,3), B=(15,-4);
draw(A -- V);
draw(V -- V+(V-A), gray);
draw(B -- V);
draw(V -- V+0.5(V-B), gray);

// La bisectriz
pair Vector1=unit(A-V)+unit(B-V);
draw (V-4*Vector1 -- V+8*Vector1, deepgreen);

// Un punto de la bisectriz
pair P1=V+5*Vector1;

// Distancias de P a las semirrectas
pen FormatoTexto=black+fontsize(6pt);
pair Vr=A-V, Nr=(-Vr.y,Vr.x);
pair Pr=intersectionpoint(V--A,P1--P1+Nr);
draw(P1 -- Pr, blue);
markrightangle(V, Pr, P1, 2mm, 0.5bp+orange);
label("d(P,r)",(P1+Pr)/2,NE,FormatoTexto);
pair Vs=B-V, Ns=(Vs.y,-Vs.x);
pair Ps=intersectionpoint(V--B,P1--P1+Ns);
draw(P1 -- Ps, blue);
markrightangle(V, Ps, P1, 2mm, 0.5bp+orange);
label("d(P,s)",(P1+Ps)/2,SE,FormatoTexto);

// La bisectriz falsa
pair Vector2=(Vector1.y,-Vector1.x);
draw (V-4*Vector2 -- V+4.2*Vector2, deepgreen);

// Un punto de la bisectriz falsa
pair P2=V+3.5*Vector2;

// Distancias de P a las semirrectas
pair Vr=A-V, Nr=(-Vr.y,Vr.x);
pair Pr=intersectionpoint(V--V+(V-A),P2--P2+Nr);
draw(P2 -- Pr, blue);
markrightangle(V, Pr, P2, 2mm, 0.5bp+orange);
label("d(P,r)",(P2+Pr)/2,SW,FormatoTexto);
pair Vs=B-V, Ns=(-Vs.y,Vs.x);
pair Ps=intersectionpoint(V--V-0.5(V-B),P2--P2+Ns);
draw(P2 -- Ps, blue);
markrightangle(V, Ps, P2, 2mm, 0.5bp+orange);
label("d(P,s)",(P2+Ps)/2,SE,FormatoTexto);

// Marcamos los puntos
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(V,FormatoPunto);
dot(B,FormatoPunto);
dot(P1,FormatoPunto);
dot(P2,FormatoPunto);
pen FormatoTexto=black+fontsize(8pt);
label("P",P1,SE,FormatoTexto);
label("P",P2,SW,FormatoTexto);
label("A",A,NE,FormatoTexto);
label("B",B,SE,FormatoTexto);

// Nombres de las rectas
label("r",(A+V)/2,NW,FormatoTexto);
label("s",(2B+V)/3,SW,FormatoTexto);
label("z",V+8.5*Vector1,FormatoTexto);
label("?",V+4.75*Vector2,FormatoTexto);
