//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Mostrar la representación del problema
// Fecha:    J.3.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 25, Ymin = -2, Ymax = 22, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(step=1, Step=5, NoZero, size=0.25mm, Size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las circunferencias
draw(circle((-1,4),sqrt(29)),blue);
draw(circle((13,10),sqrt(145)),blue);

// La recta
pair A=(1,9), B=(4,2), v=B-A;
draw(B+0.6v -- A-1.6v, red+1.5bp);

// Los puntos
dot(A,deepgreen+6pt);
dot((4,2),deepgreen+6pt);

// Los nombres
label("C",(-5,9),fontsize(10pt));
label("F",(6,21),fontsize(10pt));
label("7x+3y-34=0",A-1.75v,fontsize(8pt));
