//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Ilustrar el enunciado 1
// Fecha:    S.15.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

//markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
real x=45, y=28;
pair A0=(0,0), B0=(x,0), C0=(0,y);

// Rotación
transform R=rotate(37);
pair A=R*A0;
pair B=R*B0;
pair C=R*C0;

// El triángulo
draw(A -- B -- C -- cycle);

// El formato de texto
pen Formato=black+fontsize(14pt);

// Los ángulos
markangle(Label("$\alpha$",Formato), radius=5mm, C, B, A, 1bp+blue);
markrightangle(B, A, C, 3mm, 1bp+gray);

// La descripción de los lados
Formato=black+fontsize(10pt);
label(string(x), (A+B)/2, SE, Formato);
label(string(y), (A+C)/2, W, Formato);
