//---------------------------------------------------------------
// Fichero:  figura1.asy
// Objetivo: Mostrar la figura 1
// Fecha:    D.16.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// El punto de observación
pair A=(0,0);

// El punto de la izquierda abajo
pair B=(-5.73,0);

// El vértice de la izquierda arriba
pair C=(-5.73,3.58);

// El vértice de la derecha abajo
pair D=(4.27,0);

// El vértice de la derecha arriba
pair E=(4.27,4.58);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$32^\circ$",FormAng),
          radius=8mm, C, A, B, FormArc);
markangle(Label("$47^\circ$",FormAng),
          radius=5mm, D, A, E, FormArc);
markrightangle(C, B, A, 2mm, 1bp+gray);
markrightangle(E, D, A, 2mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.5;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(B+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(B+Separacion*(-1,0) -- C+Separacion*(-1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(D+Separacion*(1,0) -- E+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("10", (B+D)/2+Separacion*(0,-2), deepgreen+FormatoTexto);
label("x", (B+C)/2+Separacion*(-2,0), red+FormatoTexto);
label("x+1", (D+E)/2+Separacion*(3,0), red+FormatoTexto);

// Dibujamos las líneas
draw(A -- B -- C -- A -- D -- E -- A);
