//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Mostrar la figura 2
// Fecha:    D.16.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// El punto de la izquierda abajo
pair A=(0,0);

// El punto de abajo en medio
pair B=(8,0);

// El punto de abajo a la derecha
pair C=(11.6,0);

// El punto de arriba
pair D=(11.6,9.4);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$39^\circ$",FormAng),
          radius=8mm, B, A, D, FormArc);
markangle(Label("$30^\circ$",FormAng),
          radius=12mm, A, D, B, FormArc);
markrightangle(D, C, B, 2mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.5;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(A+Separacion*(0,-1) -- B+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(D+Separacion*(1,0) -- C+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("8", (A+B)/2+Separacion*(0,-2), deepgreen+FormatoTexto);
label("x", (C+D)/2+Separacion*(2,0), red+FormatoTexto);

// Dibujamos las líneas
draw(B -- C -- D, gray);
draw(A -- B -- D -- A);
