//---------------------------------------------------------------
// Fichero:  descomposicion.asy
// Objetivo: Representar el rombo descompuesto
// Fecha:    M.18.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=dir(144), B=(0,0), C=dir(36), D=A+(C-B);

// El punto auxiliar
pair Q=extension(B, B+dir(72), A, C);

// El ángulo
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$144^\circ$",FormAng), radius=3mm, D, Q, B, FormArc);

// El rombo
draw(A -- B -- C -- D -- cycle);

// Las líneas auxiliares
draw(D -- Q -- B);

