//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Mostrar la solución 1
// Fecha:    X.31.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(0,-0.8), B=(1.6,1.2), C=(3.9,0), D=(-3.5,-1.5), F=(-3.4,1.8);
pair G=(3.7,-1.1), H=(-1.8,1.8), I=(3,1.6), J=(-1.2,0), K=(2,-1.3);
pair L=(-2.3,-1.3), M=(-0.7,1.7), Q=(1.3,-1.9), R=(2.7,-1.2), T=(-2.6,0.9);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -2, Ymax = 2, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, step=0.1, NoZero, Size=1mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, E, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, N, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("F"), F, S, 5pt+black);
dot(Label("G"), G, E, 5pt+black);
dot(Label("H"), H, S, 5pt+black);
dot(Label("I"), I, N, 5pt+black);
dot(Label("J"), J, N, 5pt+black);
dot(Label("K"), K, S, 5pt+black);
dot(Label("L"), L, S, 5pt+black);
dot(Label("M"), M, S, 5pt+black);
dot(Label("Q"), Q, N, 5pt+black);
dot(Label("R"), R, NE, 5pt+black);
dot(Label("T"), T, N, 5pt+black);
