//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Mostrar el enunciado 2
// Fecha:    X.31.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = -10, Xmax = 10, Ymin = -6, Ymax = 6, Extra = 0.2;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Definición de los puntos
pair A=(10,-6), B=(0,5), C=(4,-6), D=(-10,4), F=(6,-3);
pair G=(10,1), H=(3,2), I=(-7,4), J=(0,-4), K=(9,-1);
pair L=(-8,0), M=(5,6), Q=(-3,-2), R=(-5,-3), T=(3,-2);

// Grosor de las líneas
defaultpen(2);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, NW, 5pt+black);
dot(Label("B"), B, NE, 5pt+black);
dot(Label("C"), C, NE, 5pt+black);
dot(Label("D"), D, NE, 5pt+black);
dot(Label("F"), F, SE, 5pt+black);
dot(Label("G"), G, NW, 5pt+black);
dot(Label("H"), H, NE, 5pt+black);
dot(Label("I"), I, SW, 5pt+black);
dot(Label("J"), J, SE, 5pt+black);
dot(Label("K"), K, NE, 5pt+black);
dot(Label("L"), L, SE, 5pt+black);
dot(Label("M"), M, SW, 5pt+black);
dot(Label("Q"), Q, NE, 5pt+black);
dot(Label("R"), R, SW, 5pt+black);
dot(Label("T"), T, SW, 5pt+black);
