//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Mostrar la solución 1
// Fecha:    V.2.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Caracteres no ASCII
include unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 10, Extra = 0.25;

// Definición de los puntos
pair Puntos[] = {(1,9), (2,7), (3,7), (4,6), (6,5),
                 (7,4), (8,4), (9,3), (10,2)};

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis("Número de aciertos", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Distancia (m)", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
for ( int i=0 ; i<Puntos.length ; ++i )
    { dot(Puntos[i],5pt+black); }
