//---------------------------------------------------------------
// Fichero:  escalas.asy
// Objetivo: Representar las escalas
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 3, Ymin = -4, Ymax = 4, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El origen de coordenadas
dot((0,0), 5bp+black);

