//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Mostrar el ejemplo 1
// Fecha:    J.1.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 5, Extra = 0.25;

// Definición de los puntos
pair A=(2,1), B=(4,2), C=(6,3), D=(8,4), E1=(10,5);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de cada eje
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis("Coste (euro)", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Masa (kg)", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, N, 5pt+black);
dot(Label("D"), D, N, 5pt+black);
dot(Label("E"), E1, N, 5pt+black);
