//---------------------------------------------------------------
// Fichero:  grafico.asy
// Objetivo: Representar números enteros
// Fecha:    D.4.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(14cm);

// Grosor de las líneas
defaultpen(1.5);

// El eje de abscisas
draw((-4.2,0) -- (4.2,0));

// Las abscisas que hay que marcar
pen FormatoTexto=fontsize(12pt)+Helvetica(series="b",shape="n");
for ( int i=-4 ; i<5 ; ++i )
    {
    dot((i,0), 4bp+blue);
    string Texto=string(i);
    // Añadimos un segundo signo menos para que quede más largo
    if ( i<0 ) { Texto="-"+Texto; }
    label(Texto, (i,0), N, FormatoTexto);
    }
