//---------------------------------------------------------------
// Fichero:  TresCuartos.asy
// Objetivo: Dibujar tres cuartos en un triángulo equilátero
// Fecha:    D.14.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2cm);

// Grosor de las líneas
defaultpen(1);

// El triángulo pequeño
path Triangulo = ((0,0) -- (1,0) -- (Cos(60), Sin(60)) -- cycle);

// La altura del triángulo pequeño
real Altura = Sin(60);

// Rellenamos tres sectores
fill(Triangulo, mediumgray);
fill(shift(1, 0) * Triangulo, mediumgray);
fill(shift(0.5, Altura) * Triangulo, mediumgray);

// El triángulo grande
draw(Triangulo);
draw(shift(1, 0) * Triangulo);
draw(shift(0.5, Altura) * Triangulo);
