//---------------------------------------------------------------
// Fichero:  TresNovenos.asy
// Objetivo: Dibujar tres novenos en un círculo
// Fecha:    J.18.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// El sector marcado
path Sector = ((0,0) -- (1,0) -- arc((0,0),1,0,40) -- cycle);

// Dibujamos tres sectores rotando
for ( int i=0 ; i<3 ; ++i )
    { fill(rotate(120*i) * Sector, mediumgray); }

// Una circunferencia
draw(circle((0,0), 1), black);

// Definimos el radio
path Radio = ((0,0) -- (1,0));

// Dibujamos nueve veces el radio, con rotaciones
for ( int i=0 ; i<9 ; ++i )
    { draw(rotate(40*i) * Radio); }
