//---------------------------------------------------------------
// Fichero:  CincoCuartos.asy
// Objetivo: Dibujar cinco cuartos con dos cuadrados
// Fecha:    S.13.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Separación entre los cuadrados
real Separacion = 0.5;

// Grosor de las líneas
defaultpen(1);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Los cinco cuadrados pequeños marcados
for (int i = 0; i <= 1; ++i)
    {
    for (int j = 0; j <= 1; ++j)
        { fill((shift(i, j)) * Cuadrado, mediumgray); }
    }
fill(shift(2+Separacion, 1) * Cuadrado, mediumgray);

// Dibujamos ocho veces el cuadrado pequeño, con desplazamientos
for (int v = 0; v <= 1; ++v)
    {
    for (int i = 0; i <= 1; ++i)
        {
        for (int j = 0; j <= 1; ++j)
            { draw(shift(i+2*v+v*Separacion, j) * Cuadrado); }
        }
    }
