//---------------------------------------------------------------
// Fichero:  CincoMedios.asy
// Objetivo: Dibujar cinco medios en tres círculos
// Fecha:    S.13.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Separación entre las circunferencias
real Separacion = 2.5;

// Los sectores marcados
path SectorSup = ((0,0) -- (1,0) -- arc((0,0),1,0,180) -- cycle);
path SectorInf = ((0,0) -- (1,0) -- arc((0,0),1,0,-180) -- cycle);

// Dibujamos cinco sectores
fill(SectorSup, mediumgray);
fill(SectorInf, mediumgray);
fill(shift(Separacion, 0) * SectorSup, mediumgray);
fill(shift(Separacion, 0) * SectorInf, mediumgray);
fill(shift(2*Separacion, 0) * SectorSup, mediumgray);

// La circunferencia básica
path Circunferencia = circle((0,0), 1);

// Dibujamos tres circunferencias
draw(Circunferencia, black);
draw(shift(Separacion, 0) * Circunferencia, black);
draw(shift(Separacion, 0) * Circunferencia, black);
draw(shift(2*Separacion, 0) * Circunferencia, black);

// Definimos el diámetro horizontal
path Diametro = ((-1,0) -- (1,0));

// Dibujamos tres veces el diámetro, con desplazamientos
draw(Diametro);
draw(shift(Separacion, 0) * Diametro);
draw(shift(2*Separacion, 0) * Diametro);
