//---------------------------------------------------------------
// Fichero:  CuatroTercios.asy
// Objetivo: Dibujar cuatro tercios con dos rectángulos
// Fecha:    D.14.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm, 2.5cm);

// Separación entre los rectángulos
real Separacion = 0.5;

// Grosor de las líneas
defaultpen(1);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Los cuatro cuadrados pequeños marcados
fill(shift(0, 1+Separacion) * Cuadrado, mediumgray);
fill(shift(1, 1+Separacion) * Cuadrado, mediumgray);
fill(shift(2, 1+Separacion) * Cuadrado, mediumgray);
fill(Cuadrado, mediumgray);

// Dibujamos seis veces el cuadrado pequeño, con desplazamientos
for ( int i=0; i<=2; ++i )
    {
    for ( int j=0; j<=1; ++j )
        { draw(shift(i, j+j*Separacion) * Cuadrado); }
    }
